/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.configurer.map.KeyValueRecord;
import org.codefilarete.stalactite.engine.configurer.map.RecordId;
import org.codefilarete.stalactite.engine.diff.AbstractDiff;
import org.codefilarete.stalactite.engine.runtime.CollectionUpdater;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;

class MapUpdater<SRC, SRCID, K, V, ENTITY, ENTITY_ID, KK, VV>
extends CollectionUpdater<SRC, Map.Entry<K, V>, Set<Map.Entry<K, V>>> {
    private final EntityPersister<KeyValueRecord<KK, VV, SRCID>, RecordId<KK, SRCID>> keyValueRecordPersister;
    private final ConfiguredRelationalPersister<SRC, SRCID> sourcePersister;
    private final CascadeOptions.RelationMode maintenanceMode;
    private final BiFunction<Map.Entry<K, V>, SRCID, KeyValueRecord<KK, VV, SRCID>> recordBuilder;

    public MapUpdater(Function<SRC, Set<Map.Entry<K, V>>> targetEntitiesGetter, ConfiguredRelationalPersister<ENTITY, ENTITY_ID> entityPersister, EntityPersister<KeyValueRecord<KK, VV, SRCID>, RecordId<KK, SRCID>> keyValueRecordPersister, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, CascadeOptions.RelationMode maintenanceMode, Function<? super Map.Entry<K, V>, ENTITY> entryBeanExtractor, BiFunction<Map.Entry<K, V>, SRCID, KeyValueRecord<KK, VV, SRCID>> recordBuilder) {
        super(targetEntitiesGetter, new RelationalPersisterAsEntityWriter(entityPersister, entryBeanExtractor), (O o, I i) -> {}, true, (O entry) -> entityPersister.getId(entryBeanExtractor.apply((Object)entry)));
        this.keyValueRecordPersister = keyValueRecordPersister;
        this.sourcePersister = sourcePersister;
        this.maintenanceMode = maintenanceMode;
        this.recordBuilder = recordBuilder;
    }

    protected KeyValueAssociationTableUpdateContext newUpdateContext(Duo<SRC, SRC> updatePayload) {
        return new KeyValueAssociationTableUpdateContext(updatePayload);
    }

    @Override
    protected void onAddedElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<Map.Entry<K, V>> diff) {
        super.onAddedElements(updateContext, diff);
        KeyValueRecord<KK, VV, SRCID> associationRecord = this.newRecord(updateContext.getPayload().getLeft(), diff.getReplacingInstance());
        ((KeyValueAssociationTableUpdateContext)updateContext).getAssociationRecordsToBeInserted().add(associationRecord);
    }

    @Override
    protected void onHeldElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<Map.Entry<K, V>> diff) {
        super.onHeldElements(updateContext, diff);
        Duo associationRecord = new Duo(this.newRecord(updateContext.getPayload().getLeft(), diff.getReplacingInstance()), this.newRecord(updateContext.getPayload().getLeft(), diff.getSourceInstance()));
        ((KeyValueAssociationTableUpdateContext)updateContext).getAssociationRecordsToBeUpdated().add(associationRecord);
    }

    @Override
    protected void onRemovedElements(CollectionUpdater.UpdateContext updateContext, AbstractDiff<Map.Entry<K, V>> diff) {
        super.onRemovedElements(updateContext, diff);
        KeyValueRecord<KK, VV, SRCID> associationRecord = this.newRecord(updateContext.getPayload().getLeft(), diff.getSourceInstance());
        ((KeyValueAssociationTableUpdateContext)updateContext).getAssociationRecordsToBeDeleted().add(associationRecord);
    }

    @Override
    protected void insertTargets(CollectionUpdater.UpdateContext updateContext) {
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY && this.maintenanceMode != CascadeOptions.RelationMode.ASSOCIATION_ONLY) {
            super.insertTargets(updateContext);
        }
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            super.insertTargets(updateContext);
            this.keyValueRecordPersister.insert(((KeyValueAssociationTableUpdateContext)updateContext).getAssociationRecordsToBeInserted());
        }
    }

    @Override
    protected void updateTargets(CollectionUpdater.UpdateContext updateContext, boolean allColumnsStatement) {
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY && this.maintenanceMode != CascadeOptions.RelationMode.ASSOCIATION_ONLY) {
            super.updateTargets(updateContext, allColumnsStatement);
        }
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            this.keyValueRecordPersister.update(((KeyValueAssociationTableUpdateContext)updateContext).getAssociationRecordsToBeUpdated(), allColumnsStatement);
        }
    }

    @Override
    protected void deleteTargets(CollectionUpdater.UpdateContext updateContext) {
        if (this.maintenanceMode != CascadeOptions.RelationMode.READ_ONLY) {
            this.keyValueRecordPersister.delete(((KeyValueAssociationTableUpdateContext)updateContext).getAssociationRecordsToBeDeleted());
        }
        if (this.maintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL) {
            super.deleteTargets(updateContext);
        }
    }

    private KeyValueRecord<KK, VV, SRCID> newRecord(SRC e, Map.Entry<K, V> record) {
        return this.recordBuilder.apply(record, this.sourcePersister.getId(e));
    }

    class KeyValueAssociationTableUpdateContext
    extends CollectionUpdater.UpdateContext {
        private final List<KeyValueRecord<KK, VV, SRCID>> associationRecordsToBeInserted;
        private final List<Duo<KeyValueRecord<KK, VV, SRCID>, KeyValueRecord<KK, VV, SRCID>>> associationRecordsToBeUpdated;
        private final List<KeyValueRecord<KK, VV, SRCID>> associationRecordsToBeDeleted;

        public KeyValueAssociationTableUpdateContext(Duo<SRC, SRC> updatePayload) {
            super(MapUpdater.this, updatePayload);
            this.associationRecordsToBeInserted = new ArrayList();
            this.associationRecordsToBeUpdated = new ArrayList();
            this.associationRecordsToBeDeleted = new ArrayList();
        }

        public List<KeyValueRecord<KK, VV, SRCID>> getAssociationRecordsToBeInserted() {
            return this.associationRecordsToBeInserted;
        }

        public List<Duo<KeyValueRecord<KK, VV, SRCID>, KeyValueRecord<KK, VV, SRCID>>> getAssociationRecordsToBeUpdated() {
            return this.associationRecordsToBeUpdated;
        }

        public List<KeyValueRecord<KK, VV, SRCID>> getAssociationRecordsToBeDeleted() {
            return this.associationRecordsToBeDeleted;
        }
    }

    private static class RelationalPersisterAsEntityWriter<K, V, ENTITY, ENTITY_ID>
    implements CollectionUpdater.EntityWriter<Map.Entry<K, V>> {
        private final ConfiguredRelationalPersister<ENTITY, ENTITY_ID> relationEntityPersister;
        private final Function<? super Map.Entry<K, V>, ENTITY> mapper;

        public RelationalPersisterAsEntityWriter(ConfiguredRelationalPersister<ENTITY, ENTITY_ID> relationEntityPersister, Function<? super Map.Entry<K, V>, ENTITY> mapper) {
            this.relationEntityPersister = relationEntityPersister;
            this.mapper = mapper;
        }

        @Override
        public void update(Iterable<? extends Duo<Map.Entry<K, V>, Map.Entry<K, V>>> differencesIterable, boolean allColumnsStatement) {
            this.relationEntityPersister.update(Iterables.stream(differencesIterable).map(duo -> new Duo(this.mapper.apply((Map.Entry<K, V>)duo.getLeft()), this.mapper.apply((Map.Entry<K, V>)duo.getRight()))).collect(Collectors.toSet()), allColumnsStatement);
        }

        @Override
        public void delete(Iterable<? extends Map.Entry<K, V>> entities) {
            this.relationEntityPersister.delete(Iterables.stream(entities).map(this.mapper).collect(Collectors.toSet()));
        }

        @Override
        public void insert(Iterable<? extends Map.Entry<K, V>> entities) {
            this.relationEntityPersister.insert(Iterables.stream(entities).map(this.mapper).collect(Collectors.toSet()));
        }

        @Override
        public void persist(Iterable<? extends Map.Entry<K, V>> entities) {
            this.relationEntityPersister.persist(Iterables.stream(entities).map(this.mapper).collect(Collectors.toSet()));
        }

        @Override
        public boolean isNew(Map.Entry<K, V> entity) {
            return this.relationEntityPersister.isNew(this.mapper.apply(entity));
        }

        @Override
        public void updateById(Iterable<? extends Map.Entry<K, V>> entities) {
            this.relationEntityPersister.updateById(Iterables.stream(entities).map(this.mapper).collect(Collectors.toSet()));
        }
    }
}

